

<?php $__env->startSection('admin-content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0"><?php echo e(__('app.users.title')); ?></h4>
            <p class="text-muted small mb-0"><?php echo e(__('app.users.description')); ?></p>
        </div>
        <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus-lg me-2"></i><?php echo e(__('app.users.new_user')); ?>

        </a>
    </div>

    <div class="table-responsive">
        <table class="table align-middle">
            <thead>
                <tr>
                    <th><?php echo e(__('app.users.table.name')); ?></th>
                    <th><?php echo e(__('app.users.table.email')); ?></th>
                    <th><?php echo e(__('app.users.table.role')); ?></th>
                    <th><?php echo e(__('app.users.table.created')); ?></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="fw-semibold"><?php echo e($user->name); ?></td>
                        <td><?php echo e($user->email); ?></td>
                        <td>
                            <?php if($user->role): ?>
                                <span class="badge bg-primary-subtle text-primary">
                                    <?php echo e($user->role->display_name); ?>

                                </span>
                            <?php else: ?>
                                <span class="text-muted"><?php echo e(__('app.users.no_role')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="text-muted small"><?php echo e($user->created_at->format('Y-m-d')); ?></td>
                        <td class="text-end">
                            <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="btn btn-sm btn-outline-primary"><?php echo e(__('app.users.edit')); ?></a>
                            <?php if($user->id !== auth()->id()): ?>
                                <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($user->id); ?>"><?php echo e(__('app.users.delete')); ?></button>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="mt-3">
        <?php echo e($users->links()); ?>

    </div>

    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($user->id !== auth()->id()): ?>
            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal<?php echo e($user->id); ?>" tabindex="-1" aria-labelledby="deleteModalLabel<?php echo e($user->id); ?>" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header border-0 pb-0">
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body text-center px-4 pb-4">
                            <div class="mb-3">
                                <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                    <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                                </div>
                            </div>
                            <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel<?php echo e($user->id); ?>"><?php echo e(__('app.users.delete_confirm')); ?></h5>
                            <p class="text-muted mb-0">
                                <?php echo e(__('app.users.table.name')); ?>: <strong><?php echo e($user->name); ?></strong><br>
                                <?php echo e(__('app.users.table.email')); ?>: <strong><?php echo e($user->email); ?></strong>
                            </p>
                        </div>
                        <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                            <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                                <?php echo e(__('app.users.form.cancel')); ?>

                            </button>
                            <form action="<?php echo e(route('admin.users.destroy', $user)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-rounded">
                                    <i class="bi bi-trash me-2"></i><?php echo e(__('app.users.delete')); ?>

                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>





<?php echo $__env->make('layouts.admin', ['title' => __('app.users.title')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/admin/users/index.blade.php ENDPATH**/ ?>