<?php $__env->startSection('admin-content'); ?>
    <div class="mb-4">
        <h4 class="fw-bold mb-1"><?php echo e($transaction->type === 'income' ? __('app.transactions.income') : __('app.transactions.expense')); ?> · <?php echo e($transaction->category); ?></h4>
        <div class="<?php echo e($transaction->type === 'income' ? 'text-success' : 'text-danger'); ?> fw-bold fs-4">
            <?php echo e($transaction->type === 'income' ? '+' : '-'); ?><?php echo e(number_format($transaction->amount, 2)); ?>

        </div>
        <p class="text-muted mb-0"><?php echo e(__('app.transactions.date')); ?>: <?php echo e(\Illuminate\Support\Carbon::parse($transaction->occurred_on)->format('d M Y')); ?></p>
        <p class="text-muted"><?php echo e(__('app.transactions.cashbox')); ?>: <?php echo e($transaction->cashbox->name ?? '—'); ?></p>
    </div>

    <p><?php echo e($transaction->description); ?></p>

    <div class="d-flex gap-2">
        <?php if(! $transaction->reference_type): ?>
            <a href="<?php echo e(route('admin.transactions.edit', $transaction)); ?>" class="btn btn-primary btn-rounded"><?php echo e(__('app.transactions.edit')); ?></a>
            <form action="<?php echo e(route('admin.transactions.destroy', $transaction)); ?>" method="POST" onsubmit="return confirm('<?php echo e(__('app.transactions.delete_confirm')); ?>')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button class="btn btn-outline-danger btn-rounded" type="submit"><?php echo e(__('app.transactions.delete')); ?></button>
            </form>
        <?php else: ?>
            <span class="badge bg-secondary-subtle text-secondary"><?php echo e(__('app.transactions.locked')); ?></span>
        <?php endif; ?>
        <a href="<?php echo e(route('admin.transactions.index')); ?>" class="btn btn-outline-secondary btn-rounded"><?php echo e(__('app.transactions.back')); ?></a>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', ['title' => __('app.transactions.show_title')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/admin/transactions/show.blade.php ENDPATH**/ ?>