<?php $__env->startSection('admin-content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-1"><?php echo e($cashbox->name); ?></h4>
            <p class="text-muted mb-0"><?php echo e(__('app.cashboxes.show.balance')); ?>: <?php echo e(number_format($cashbox->current_balance, 2)); ?></p>
        </div>
        <a href="<?php echo e(route('admin.cashboxes.edit', $cashbox)); ?>" class="btn btn-outline-primary btn-rounded"><?php echo e(__('app.cashboxes.show.edit')); ?></a>
    </div>

    <div class="table-responsive">
        <table class="table">
            <thead>
                <tr>
                    <th><?php echo e(__('app.cashboxes.show.date')); ?></th>
                    <th><?php echo e(__('app.cashboxes.show.direction')); ?></th>
                    <th><?php echo e(__('app.cashboxes.show.amount')); ?></th>
                    <th><?php echo e(__('app.cashboxes.show.balance')); ?></th>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_transactions')): ?>
                        <th class="text-end"><?php echo e(__('app.cashboxes.show.actions')); ?></th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $cashbox->entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($entry->created_at->format('d M Y H:i')); ?></td>
                        <td class="text-capitalize"><?php echo e($entry->direction === 'in' ? __('app.cashboxes.show.in') : __('app.cashboxes.show.out')); ?></td>
                        <td class="<?php echo e($entry->direction === 'in' ? 'text-success' : 'text-danger'); ?>">
                            <?php echo e($entry->direction === 'in' ? '+' : '-'); ?><?php echo e(number_format($entry->amount, 2)); ?>

                        </td>
                        <td><?php echo e(number_format($entry->running_balance, 2)); ?></td>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_transactions')): ?>
                            <td class="text-end">
                                <button type="button" class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($entry->id); ?>">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(auth()->user()->hasPermission('manage_transactions') ? '5' : '4'); ?>" class="text-center text-muted py-5"><?php echo e(__('app.cashboxes.show.none')); ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_transactions')): ?>
        <?php $__currentLoopData = $cashbox->entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal<?php echo e($entry->id); ?>" tabindex="-1" aria-labelledby="deleteModalLabel<?php echo e($entry->id); ?>" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header border-0 pb-0">
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body text-center px-4 pb-4">
                            <div class="mb-3">
                                <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                    <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                                </div>
                            </div>
                            <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel<?php echo e($entry->id); ?>"><?php echo e(__('app.cashboxes.show.delete_confirm')); ?></h5>
                            <p class="text-muted mb-0">
                                <?php echo e(__('app.cashboxes.show.direction')); ?>: <strong><?php echo e($entry->direction === 'in' ? __('app.cashboxes.show.in') : __('app.cashboxes.show.out')); ?></strong><br>
                                <?php echo e(__('app.cashboxes.show.amount')); ?>: <strong><?php echo e(number_format($entry->amount, 2)); ?></strong><br>
                                <?php echo e(__('app.cashboxes.show.date')); ?>: <strong><?php echo e($entry->created_at->format('d M Y H:i')); ?></strong>
                                <?php if($entry->transaction && $entry->transaction->reference_type): ?>
                                    <br><span class="badge bg-warning-subtle text-warning mt-2"><?php echo e(__('app.cashboxes.show.linked_to_order')); ?></span>
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                            <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                                <?php echo e(__('app.cashboxes.show.cancel')); ?>

                            </button>
                            <form action="<?php echo e(route('admin.cashboxes.entries.destroy', ['cashbox' => $cashbox->id, 'entry' => $entry->id])); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-rounded">
                                    <i class="bi bi-trash me-2"></i><?php echo e(__('app.cashboxes.show.delete')); ?>

                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', ['title' => $cashbox->name], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/admin/cashboxes/show.blade.php ENDPATH**/ ?>