<?php $__env->startSection('admin-content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0"><?php echo e(__('app.items.catalog')); ?></h4>
            <p class="text-muted small mb-0"><?php echo e(__('app.items.description')); ?></p>
        </div>
        <a href="<?php echo e(route('admin.items.create')); ?>" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus-lg me-2"></i><?php echo e(__('app.items.new_item')); ?>

        </a>
    </div>

    <div class="table-responsive">
        <table class="table align-middle">
            <thead>
                <tr>
                    <th><?php echo e(__('app.items.table.item')); ?></th>
                    <th><?php echo e(__('app.items.table.wash')); ?></th>
                    <th><?php echo e(__('app.items.table.iron')); ?></th>
                    <th><?php echo e(__('app.items.table.status')); ?></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="d-flex align-items-center gap-3">
                            <img src="<?php echo e($item->image_url); ?>" alt="" class="rounded-3" style="width:56px;height:56px;object-fit:cover;">
                            <div>
                                <div class="fw-semibold"><?php echo e($item->name); ?></div>
                                <small class="text-muted"><?php echo e($item->slug); ?></small>
                            </div>
                        </td>
                        <td><?php echo e(number_format($item->default_wash_price, 2)); ?></td>
                        <td><?php echo e(number_format($item->default_iron_price, 2)); ?></td>
                        <td>
                            <span class="badge <?php echo e($item->is_active ? 'bg-success-subtle text-success' : 'bg-secondary-subtle text-secondary'); ?>">
                                <?php echo e($item->is_active ? __('app.items.active') : __('app.items.hidden')); ?>

                            </span>
                        </td>
                        <td class="text-end">
                            <a href="<?php echo e(route('admin.items.edit', $item)); ?>" class="btn btn-sm btn-outline-primary"><?php echo e(__('app.items.edit')); ?></a>
                            <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?php echo e($item->id); ?>"><?php echo e(__('app.items.delete')); ?></button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>

    <div class="mt-3">
        <?php echo e($items->links()); ?>

    </div>

    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal<?php echo e($item->id); ?>" tabindex="-1" aria-labelledby="deleteModalLabel<?php echo e($item->id); ?>" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header border-0 pb-0">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center px-4 pb-4">
                        <div class="mb-3">
                            <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                            </div>
                        </div>
                        <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel<?php echo e($item->id); ?>"><?php echo e(__('app.items.delete_confirm')); ?></h5>
                        <p class="text-muted mb-0">
                            <?php echo e(__('app.items.table.item')); ?>: <strong><?php echo e($item->name); ?></strong>
                        </p>
                    </div>
                    <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                        <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                            <?php echo e(__('app.items.form.cancel')); ?>

                        </button>
                        <form action="<?php echo e(route('admin.items.destroy', $item)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-rounded">
                                <i class="bi bi-trash me-2"></i><?php echo e(__('app.items.delete')); ?>

                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', ['title' => __('app.items.title')], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/admin/items/index.blade.php ENDPATH**/ ?>