<?php $__env->startSection('title', trim(($title ?? __('app.admin.dashboard')) . ' · ' . __('app.brand'))); ?>

<?php $__env->startSection('content'); ?>
    <div class="row g-4">
        <div class="col-12">
            <div class="masbana-card p-4">
                <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3">
                    <div>
                        <p class="heading-label mb-1"><?php echo e(__('app.tagline')); ?></p>
                        <h1 class="h3 fw-bold m-0"><?php echo e($title ?? __('app.admin.dashboard')); ?></h1>
                    </div>
                    <div class="d-flex flex-wrap gap-2">
                        <a href="<?php echo e(route('service-orders.index')); ?>" class="btn btn-outline-primary btn-rounded">
                            <i class="bi bi-plus-circle me-2"></i><?php echo e(__('app.admin.quick_actions.new_service')); ?>

                        </a>
                        <a href="<?php echo e(route('admin.settings.edit')); ?>" class="btn btn-primary btn-rounded">
                            <i class="bi bi-gear me-2"></i><?php echo e(__('app.admin.quick_actions.settings')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <?php if(auth()->guard()->check()): ?>
            <div class="col-12">
                <div class="alert alert-info rounded-4 mb-0 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center gap-2">
                        <i class="bi bi-person-circle fs-5"></i>
                        <div>
                            <div class="fw-semibold"><?php echo e(auth()->user()->name); ?></div>
                            <small class="text-muted"><?php echo e(auth()->user()->email); ?> 
                                <?php if(auth()->user()->role): ?>
                                    · <?php echo e(auth()->user()->role->display_name); ?>

                                <?php endif; ?>
                            </small>
                        </div>
                    </div>
                    <form action="<?php echo e(route('logout')); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-sm btn-outline-danger btn-rounded">
                            <i class="bi bi-box-arrow-right me-1"></i><?php echo e(__('app.auth.logout')); ?>

                        </button>
                    </form>
                </div>
            </div>
        <?php endif; ?>

        <?php
            $trialService = app(\App\Services\TrialService::class);
            $licenseService = app(\App\Services\LicenseService::class);
            $hasLicense = $licenseService->verifyLocal();
            $trialInfo = $trialService->getTrialInfo();
        ?>

        <?php if(!$hasLicense && $trialInfo['is_expiring_soon']): ?>
            <div class="col-12">
                <div class="trial-warning-notification mb-0">
                    <div class="d-flex align-items-start gap-3">
                        <div class="trial-warning-icon">
                            <i class="bi bi-exclamation-triangle-fill"></i>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-2">
                                <h6 class="fw-bold mb-0">
                                    <i class="bi bi-clock-history me-2"></i><?php echo e(__('app.trial.warning_title')); ?>

                                </h6>
                                <span class="badge bg-warning-subtle text-warning-emphasis px-3 py-2">
                                    <i class="bi bi-calendar-x me-1"></i><?php echo e($trialInfo['days_remaining']); ?> <?php echo e(__('app.trial.days')); ?> <?php echo e(__('app.trial.remaining')); ?>

                                </span>
                            </div>
                            <p class="mb-3 text-muted"><?php echo e(__('app.trial.warning_message', ['days' => $trialInfo['days_remaining']])); ?></p>
                            <div class="d-flex gap-2 flex-wrap">
                                <a href="<?php echo e(route('license.activate')); ?>" class="btn btn-warning btn-sm btn-rounded">
                                    <i class="bi bi-key-fill me-2"></i><?php echo e(__('app.trial.activate_license')); ?>

                                </a>
                                <button type="button" class="btn btn-outline-secondary btn-sm btn-rounded" onclick="this.closest('.trial-warning-notification').style.display='none'">
                                    <i class="bi bi-x-lg me-1"></i><?php echo e(__('app.trial.dismiss')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="col-12 col-lg-3">
            <div class="masbana-card p-3 h-100">
                <div class="list-group list-group-flush">
                    <a href="<?php echo e(route('admin.dashboard')); ?>" class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                        <i class="bi bi-speedometer me-2"></i> <?php echo e(__('app.admin.dashboard')); ?>

                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_orders')): ?>
                        <a href="<?php echo e(route('admin.orders.index')); ?>" class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.orders.*') ? 'active' : ''); ?>">
                            <i class="bi bi-receipt-cutoff me-2"></i> <?php echo e(__('app.admin.orders')); ?>

                        </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_items')): ?>
                        <a href="<?php echo e(route('admin.items.index')); ?>" class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.items.*') ? 'active' : ''); ?>">
                            <i class="bi bi-bag-check me-2"></i> <?php echo e(__('app.admin.items')); ?>

                        </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_transactions')): ?>
                        <a href="<?php echo e(route('admin.transactions.index')); ?>" class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.transactions.*') ? 'active' : ''); ?>">
                            <i class="bi bi-cash-stack me-2"></i> <?php echo e(__('app.admin.transactions')); ?>

                        </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_cashboxes')): ?>
                        <a href="<?php echo e(route('admin.cashboxes.index')); ?>" class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.cashboxes.*') ? 'active' : ''); ?>">
                            <i class="bi bi-safe2 me-2"></i> <?php echo e(__('app.admin.cashbox')); ?>

                        </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_users')): ?>
                        <a href="<?php echo e(route('admin.users.index')); ?>" class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>">
                            <i class="bi bi-people me-2"></i> <?php echo e(__('app.admin.users')); ?>

                        </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_roles')): ?>
                        <a href="<?php echo e(route('admin.roles.index')); ?>" class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.roles.*') ? 'active' : ''); ?>">
                            <i class="bi bi-shield-check me-2"></i> <?php echo e(__('app.admin.roles')); ?>

                        </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage_permissions')): ?>
                        <a href="<?php echo e(route('admin.permissions.index')); ?>" class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.permissions.*') ? 'active' : ''); ?>">
                            <i class="bi bi-key me-2"></i> <?php echo e(__('app.admin.permissions')); ?>

                        </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_settings')): ?>
                        <a href="<?php echo e(route('admin.settings.edit')); ?>" class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.settings.*') ? 'active' : ''); ?>">
                            <i class="bi bi-gear me-2"></i> <?php echo e(__('app.admin.settings')); ?>

                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="col-12 col-lg-9">
            <div class="masbana-card p-4">
                <?php echo $__env->yieldContent('admin-content'); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Lavandera\resources\views/layouts/admin.blade.php ENDPATH**/ ?>