@extends('layouts.app')

@section('title', __('app.front.receipt.title') . ' · ' . $serviceOrder->order_number)

@push('styles')
<style>
    @media print {
        /* إخفاء القائمة والهيدر */
        nav,
        .btn,
        .no-print,
        footer,
        .footer-masbana {
            display: none !important;
        }

        /* إزالة الهوامش والمسافات */
        body {
            margin: 0;
            padding: 0;
            background: white;
        }

        .container {
            max-width: 100%;
            padding: 0;
        }

        /* تنسيق الإيصال للطباعة */
        .masbana-card {
            box-shadow: none;
            border: none;
            padding: 20px !important;
            margin: 0;
        }

        /* تحسين الطباعة */
        @page {
            size: A4;
            margin: 1cm;
        }

        /* إخفاء أي عناصر إضافية */
        main::before,
        main::after {
            display: none;
        }

        @if(request('copy') == 2)
            /* ضغط المحتوى ليناسب صفحة واحدة عند طباعة نسختين */
            @page {
                margin: 0.5cm;
            }
            .masbana-card {
                padding: 1rem !important;
                border: 1px solid #eee !important; /* إضافة حدود خفيفة للفصل */
            }
            body {
                font-size: 12px;
            }
            h1.h4 {
                font-size: 1.1rem !important;
            }
            .mb-3 {
                margin-bottom: 0.5rem !important;
            }
            .mt-4 {
                margin-top: 1rem !important;
            }
            .table td, .table th {
                padding: 0.25rem 0.5rem !important;
            }
            /* تقليل المسافة الفاصلة */
            .my-4 {
                margin-top: 0.5rem !important;
                margin-bottom: 0.5rem !important;
            }
        @endif
    }
</style>
@endpush

@section('content')
    @php
        $copyCount = request('copy') == 2 ? 2 : 1;
    @endphp

    @for ($i = 0; $i < $copyCount; $i++)
        <div class="masbana-card p-4 {{ $i > 0 ? 'mt-4' : '' }}" style="page-break-inside: avoid;">
            <div class="d-flex justify-content-between align-items-start mb-3">
                <div>
                    <h1 class="h4 fw-bold mb-1">{{ $settings['company_name'] }}</h1>
                    <div class="text-muted small">
                        {{ $settings['company_address'] }} · {{ $settings['company_phone'] }}
                    </div>
                    <div class="text-muted small">{{ __('app.front.receipt.copy') }} {{ $copyCount == 2 ? ($i + 1) : request('copy', 1) }} {{ __('app.front.receipt.of') }} {{ $settings['receipt_copies'] }}</div>
                </div>
                <div class="text-end">
                    <div class="fw-semibold">{{ __('app.front.receipt.order') }} #{{ $serviceOrder->order_number }}</div>
                    <div class="text-muted small">{{ __('app.front.receipt.barcode') }}: {{ $serviceOrder->barcode }}</div>
                    <div class="text-muted small">{{ __('app.front.receipt.date') }}: {{ $serviceOrder->created_at->format('d M Y H:i') }}</div>
                </div>
            </div>

            <div class="d-flex flex-wrap gap-3 mb-3 align-items-start">
                <div class="flex-grow-1">
                    <span class="text-muted small">{{ __('app.front.receipt.customer') }}:</span>
                    <span class="fw-semibold ms-1">{{ $serviceOrder->customer_name ?? __('app.front.receipt.walk_in') }}</span>
                    <span class="text-muted ms-2">{{ __('app.front.receipt.gender') }}: {{ __('app.front.' . $serviceOrder->gender) }}</span>
                </div>
                <div>
                    <span class="text-muted small">{{ __('app.front.receipt.service') }}:</span>
                    <span class="fw-semibold ms-1">{{ __('app.front.' . $serviceOrder->service_type) }}</span>
                    <span class="text-muted ms-2">{{ __('app.front.receipt.status') }}: {{ __('app.orders.show.statuses.' . $serviceOrder->status) }}</span>
                </div>
            </div>

            <table class="table table-borderless align-middle mb-3">
                <thead class="table-light">
                    <tr>
                        <th>{{ __('app.front.receipt.item') }}</th>
                        <th class="text-center">{{ __('app.front.receipt.service') }}</th>
                        <th class="text-center">{{ __('app.front.receipt.qty') }}</th>
                        <th class="text-end">{{ __('app.front.receipt.unit') }}</th>
                        <th class="text-end">{{ __('app.front.receipt.total') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($serviceOrder->items as $item)
                        <tr>
                            <td>
                                {{ $item->clothingItem->name }}
                                @if($item->color)
                                    @php
                                        $colorMap = [
                                            'white' => '#ffffff',
                                            'black' => '#000000',
                                            'red' => '#dc3545',
                                            'blue' => '#0d6efd',
                                            'green' => '#198754',
                                            'yellow' => '#ffc107',
                                            'orange' => '#fd7e14',
                                            'purple' => '#6f42c1',
                                            'pink' => '#e91e63',
                                            'brown' => '#8b4513',
                                            'gray' => '#6c757d',
                                            'beige' => '#f5f5dc',
                                            'navy' => '#001f3f',
                                            'other' => '#cccccc'
                                        ];
                                        $hexColor = $colorMap[$item->color] ?? '#cccccc';
                                        $textColor = (in_array($item->color, ['white', 'beige', 'yellow'])) ? '#000000' : '#ffffff';
                                    @endphp
                                    <span class="badge ms-2" style="background-color: {{ $hexColor }}; color: {{ $textColor }}; border: 1px solid {{ ($item->color == 'white' || $item->color == 'beige') ? '#ddd' : 'rgba(0,0,0,0.1)' }};">{{ __('app.front.colors.' . $item->color) }}</span>
                                @endif
                            </td>
                            <td class="text-center">
                                @if($item->service_type)
                                    <span class="badge bg-primary-subtle text-primary">{{ __('app.front.' . $item->service_type) }}</span>
                                @else
                                    <span class="badge bg-primary-subtle text-primary">{{ __('app.front.' . $serviceOrder->service_type) }}</span>
                                @endif
                            </td>
                            <td class="text-center">{{ $item->quantity }}</td>
                            <td class="text-end">{{ $settings['currency'] }} {{ number_format($item->unit_price, 2) }}</td>
                            <td class="text-end">{{ $settings['currency'] }} {{ number_format($item->line_total, 2) }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="4" class="text-end text-muted">{{ __('app.front.receipt.subtotal') }}</td>
                        <td class="text-end">{{ $settings['currency'] }} {{ number_format($serviceOrder->subtotal, 2) }}</td>
                    </tr>
                    <tr>
                        <td colspan="4" class="text-end text-muted">{{ __('app.front.receipt.discount') }}</td>
                        <td class="text-end">- {{ $settings['currency'] }} {{ number_format($serviceOrder->discount_amount, 2) }}</td>
                    </tr>
                    <tr>
                        <td colspan="4" class="text-end fw-bold">{{ __('app.front.receipt.total') }}</td>
                        <td class="text-end fw-bold">{{ $settings['currency'] }} {{ number_format($serviceOrder->total, 2) }}</td>
                    </tr>
                </tfoot>
            </table>

            <div class="receipt-bottom-section d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mt-3">
                <div>
                    <small class="text-muted">{{ __('app.front.receipt.payment_status') }}: {{ __('app.orders.show.statuses.' . $serviceOrder->payment_status) }}</small><br>
                    <small class="text-muted">{{ __('app.front.receipt.thank_you') }}</small>
                </div>
                <div class="text-center">
                    <svg class="receipt-barcode w-100" style="max-width:320px;"></svg>
                    <div class="small text-muted mt-2">{{ __('app.front.receipt.scan_hint') }}</div>
                </div>
                @if($i == 0)
                    <button class="btn btn-primary btn-rounded mt-3 mt-md-0 no-print" onclick="window.print()">
                        <i class="bi bi-printer me-2"></i>{{ __('app.front.receipt.print') }}
                    </button>
                @endif
            </div>
        </div>
        @if($i < $copyCount - 1)
            <div class="d-print-block d-none border-bottom border-secondary border-dashed my-4" style="border-style: dashed !important;"></div>
        @endif
    @endfor
@endsection

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            JsBarcode(".receipt-barcode", "{{ $serviceOrder->barcode }}", {
                format: "CODE128",
                lineColor: "#0d1b2a",
                width: 2,
                height: 80,
                displayValue: true,
            });
        });
    </script>
@endpush


