@extends('layouts.admin', ['title' => __('app.users.title')])

@section('admin-content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0">{{ __('app.users.title') }}</h4>
            <p class="text-muted small mb-0">{{ __('app.users.description') }}</p>
        </div>
        <a href="{{ route('admin.users.create') }}" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus-lg me-2"></i>{{ __('app.users.new_user') }}
        </a>
    </div>

    <div class="table-responsive">
        <table class="table align-middle">
            <thead>
                <tr>
                    <th>{{ __('app.users.table.name') }}</th>
                    <th>{{ __('app.users.table.email') }}</th>
                    <th>{{ __('app.users.table.role') }}</th>
                    <th>{{ __('app.users.table.created') }}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach ($users as $user)
                    <tr>
                        <td class="fw-semibold">{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>
                            @if($user->role)
                                <span class="badge bg-primary-subtle text-primary">
                                    {{ $user->role->display_name }}
                                </span>
                            @else
                                <span class="text-muted">{{ __('app.users.no_role') }}</span>
                            @endif
                        </td>
                        <td class="text-muted small">{{ $user->created_at->format('Y-m-d') }}</td>
                        <td class="text-end">
                            <a href="{{ route('admin.users.edit', $user) }}" class="btn btn-sm btn-outline-primary">{{ __('app.users.edit') }}</a>
                            @if($user->id !== auth()->id())
                                <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $user->id }}">{{ __('app.users.delete') }}</button>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="mt-3">
        {{ $users->links() }}
    </div>

    @foreach ($users as $user)
        @if($user->id !== auth()->id())
            <!-- Delete Confirmation Modal -->
            <div class="modal fade" id="deleteModal{{ $user->id }}" tabindex="-1" aria-labelledby="deleteModalLabel{{ $user->id }}" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header border-0 pb-0">
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body text-center px-4 pb-4">
                            <div class="mb-3">
                                <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                    <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                                </div>
                            </div>
                            <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel{{ $user->id }}">{{ __('app.users.delete_confirm') }}</h5>
                            <p class="text-muted mb-0">
                                {{ __('app.users.table.name') }}: <strong>{{ $user->name }}</strong><br>
                                {{ __('app.users.table.email') }}: <strong>{{ $user->email }}</strong>
                            </p>
                        </div>
                        <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                            <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                                {{ __('app.users.form.cancel') }}
                            </button>
                            <form action="{{ route('admin.users.destroy', $user) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-rounded">
                                    <i class="bi bi-trash me-2"></i>{{ __('app.users.delete') }}
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    @endforeach
@endsection




