@extends('layouts.admin', ['title' => __('app.users.edit_title')])

@section('admin-content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0">{{ __('app.users.edit_user') }}</h4>
            <p class="text-muted small mb-0">{{ __('app.users.edit_description') }}</p>
        </div>
        <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary btn-rounded">
            <i class="bi bi-arrow-left me-2"></i>{{ __('app.users.back') }}
        </a>
    </div>

    <form action="{{ route('admin.users.update', $user) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="row g-3">
            <div class="col-12 col-md-6">
                <label for="name" class="form-label fw-semibold">{{ __('app.users.form.name') }}</label>
                <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $user->name) }}" required>
                @error('name')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12 col-md-6">
                <label for="email" class="form-label fw-semibold">{{ __('app.users.form.email') }}</label>
                <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', $user->email) }}" required>
                @error('email')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12 col-md-6">
                <label for="password" class="form-label fw-semibold">{{ __('app.users.form.password') }}</label>
                <input type="password" class="form-control @error('password') is-invalid @enderror" id="password" name="password">
                <small class="text-muted">{{ __('app.users.form.password_optional') }}</small>
                @error('password')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12 col-md-6">
                <label for="password_confirmation" class="form-label fw-semibold">{{ __('app.users.form.password_confirmation') }}</label>
                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation">
            </div>

            <div class="col-12">
                <label for="role_id" class="form-label fw-semibold">{{ __('app.users.form.role') }}</label>
                <select class="form-select @error('role_id') is-invalid @enderror" id="role_id" name="role_id" required>
                    <option value="">{{ __('app.users.form.select_role') }}</option>
                    @foreach($roles as $role)
                        <option value="{{ $role->id }}" {{ old('role_id', $user->role_id) == $role->id ? 'selected' : '' }}>
                            {{ $role->display_name }}
                        </option>
                    @endforeach
                </select>
                @error('role_id')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12">
                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary btn-rounded">
                        <i class="bi bi-check-lg me-2"></i>{{ __('app.users.form.save') }}
                    </button>
                    <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary btn-rounded">
                        {{ __('app.users.form.cancel') }}
                    </a>
                </div>
            </div>
        </div>
    </form>
@endsection




