@extends('layouts.admin', ['title' => __('app.transactions.title')])

@section('admin-content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0">{{ __('app.transactions.cashflow_monitor') }}</h4>
            <p class="text-muted small mb-0">{{ __('app.transactions.description') }}</p>
        </div>
        <a href="{{ route('admin.transactions.create') }}" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus-lg me-2"></i>{{ __('app.transactions.new_transaction') }}
        </a>
    </div>

    <form class="row g-2 align-items-end mb-4">
        <div class="col-md-3">
            <label class="form-label">{{ __('app.transactions.type') }}</label>
            <select name="type" class="form-select rounded-4">
                <option value="">{{ __('app.transactions.all') }}</option>
                <option value="income" @selected(request('type') === 'income')>{{ __('app.transactions.income') }}</option>
                <option value="expense" @selected(request('type') === 'expense')>{{ __('app.transactions.expense') }}</option>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label">{{ __('app.transactions.from') }}</label>
            <input type="date" name="from" class="form-control rounded-4" value="{{ request('from') }}">
        </div>
        <div class="col-md-3">
            <label class="form-label">{{ __('app.transactions.to') }}</label>
            <input type="date" name="to" class="form-control rounded-4" value="{{ request('to') }}">
        </div>
        <div class="col-md-3">
            <button class="btn btn-outline-primary btn-rounded w-100" type="submit">{{ __('app.transactions.apply') }}</button>
        </div>
    </form>

    <div class="table-responsive">
        <table class="table align-middle">
            <thead>
                <tr>
                    <th>{{ __('app.transactions.date') }}</th>
                    <th>{{ __('app.transactions.type') }}</th>
                    <th>{{ __('app.transactions.category') }}</th>
                    <th>{{ __('app.transactions.amount') }}</th>
                    <th>{{ __('app.transactions.cashbox') }}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($transactions as $transaction)
                    <tr>
                        <td>{{ \Illuminate\Support\Carbon::parse($transaction->occurred_on)->format('d M Y') }}</td>
                        <td class="text-capitalize">{{ $transaction->type === 'income' ? __('app.transactions.income') : __('app.transactions.expense') }}</td>
                        <td>{{ $transaction->category }}</td>
                        <td class="{{ $transaction->type === 'income' ? 'text-success' : 'text-danger' }}">
                            {{ $transaction->type === 'income' ? '+' : '-' }}{{ number_format($transaction->amount, 2) }}
                        </td>
                        <td>{{ $transaction->cashbox->name ?? '—' }}</td>
                        <td class="text-end">
                            <a href="{{ route('admin.transactions.show', $transaction) }}" class="btn btn-sm btn-outline-primary">{{ __('app.transactions.view') }}</a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" class="text-center text-muted py-5">{{ __('app.transactions.none') }}</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{ $transactions->links() }}
@endsection


