@extends('layouts.admin', ['title' => __('app.transactions.edit_title')])

@section('admin-content')
    <form action="{{ route('admin.transactions.update', $transaction) }}" method="POST" class="row g-3">
        @csrf
        @method('PUT')
        <div class="col-md-6">
            <label class="form-label">{{ __('app.transactions.category') }}</label>
            <input type="text" name="category" class="form-control rounded-4" value="{{ old('category', $transaction->category) }}" required>
        </div>
        <div class="col-md-12">
            <label class="form-label">{{ __('app.transactions.description') }}</label>
            <textarea name="description" rows="4" class="form-control rounded-4">{{ old('description', $transaction->description) }}</textarea>
        </div>
        <div class="col-12 d-flex gap-2">
            <button class="btn btn-primary btn-rounded" type="submit">{{ __('app.transactions.save') }}</button>
            <a href="{{ route('admin.transactions.show', $transaction) }}" class="btn btn-outline-secondary btn-rounded">{{ __('app.transactions.cancel') }}</a>
        </div>
    </form>
@endsection


