@extends('layouts.admin', ['title' => __('app.transactions.new_title')])

@section('admin-content')
    <form action="{{ route('admin.transactions.store') }}" method="POST" class="row g-3">
        @csrf
        <div class="col-md-6">
            <label class="form-label">{{ __('app.transactions.type') }}</label>
            <select name="type" class="form-select rounded-4" required>
                <option value="income">{{ __('app.transactions.income') }}</option>
                <option value="expense">{{ __('app.transactions.expense') }}</option>
            </select>
        </div>
        <div class="col-md-6">
            <label class="form-label">{{ __('app.transactions.category') }}</label>
            <input type="text" name="category" class="form-control rounded-4" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">{{ __('app.transactions.amount') }}</label>
            <input type="number" step="0.5" min="0" name="amount" class="form-control rounded-4" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">{{ __('app.transactions.date') }}</label>
            <input type="date" name="occurred_on" class="form-control rounded-4" value="{{ now()->format('Y-m-d') }}" required>
        </div>
        <div class="col-md-12">
            <label class="form-label">{{ __('app.transactions.cashbox') }}</label>
            <select name="cashbox_id" class="form-select rounded-4" required>
                @foreach ($cashboxes as $cashbox)
                    <option value="{{ $cashbox->id }}">{{ $cashbox->name }} ({{ number_format($cashbox->current_balance, 2) }})</option>
                @endforeach
            </select>
        </div>
        <div class="col-12">
            <label class="form-label">{{ __('app.transactions.description') }}</label>
            <textarea name="description" rows=3 class="form-control rounded-4" placeholder="{{ __('app.transactions.optional_notes') }}"></textarea>
        </div>
        <div class="col-12 d-flex gap-2">
            <button class="btn btn-primary btn-rounded" type="submit">{{ __('app.transactions.save') }}</button>
            <a href="{{ route('admin.transactions.index') }}" class="btn btn-outline-secondary btn-rounded">{{ __('app.transactions.cancel') }}</a>
        </div>
    </form>
@endsection


