@extends('layouts.admin', ['title' => __('app.settings.title')])

@section('admin-content')
    <form action="{{ route('admin.settings.update') }}" method="POST" class="row g-3">
        @csrf
        <div class="col-md-6">
            <label class="form-label">{{ __('app.settings.company_name') }}</label>
            <input type="text" name="company_name" class="form-control rounded-4" value="{{ old('company_name', $settings['company_name']) }}" required>
        </div>
        <div class="col-md-6">
            <label class="form-label">{{ __('app.settings.phone') }}</label>
            <input type="text" name="company_phone" class="form-control rounded-4" value="{{ old('company_phone', $settings['company_phone']) }}">
        </div>
        <div class="col-md-12">
            <label class="form-label">{{ __('app.settings.address') }}</label>
            <input type="text" name="company_address" class="form-control rounded-4" value="{{ old('company_address', $settings['company_address']) }}">
        </div>
        <div class="col-md-4">
            <label class="form-label">{{ __('app.settings.barcode_prefix') }}</label>
            <input type="text" name="barcode_prefix" class="form-control rounded-4" value="{{ old('barcode_prefix', $settings['barcode_prefix']) }}" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">{{ __('app.settings.order_prefix') }}</label>
            <input type="text" name="order_prefix" class="form-control rounded-4" value="{{ old('order_prefix', $settings['order_prefix']) }}" required>
        </div>
        <div class="col-md-4">
            <label class="form-label">{{ __('app.settings.receipt_copies') }}</label>
            <select name="receipt_copies" class="form-select rounded-4">
                <option value="1" @selected(old('receipt_copies', $settings['receipt_copies']) == 1)>1</option>
                <option value="2" @selected(old('receipt_copies', $settings['receipt_copies']) == 2)>2</option>
            </select>
        </div>
        <div class="col-md-4">
            <label class="form-label">{{ __('app.settings.currency') }}</label>
            <input type="text" name="currency" class="form-control rounded-4" value="{{ old('currency', $settings['currency']) }}" required>
        </div>
        <div class="col-12 d-flex gap-2">
            <button class="btn btn-primary btn-rounded" type="submit">{{ __('app.settings.save_changes') }}</button>
            <a href="{{ route('admin.dashboard') }}" class="btn btn-outline-secondary btn-rounded">{{ __('app.settings.cancel') }}</a>
        </div>
    </form>
@endsection


