@extends('layouts.admin', ['title' => __('app.permissions.title')])

@section('admin-content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0">{{ __('app.permissions.title') }}</h4>
            <p class="text-muted small mb-0">{{ __('app.permissions.description') }}</p>
        </div>
        <a href="{{ route('admin.permissions.create') }}" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus-lg me-2"></i>{{ __('app.permissions.new_permission') }}
        </a>
    </div>

    @foreach($permissions as $group => $groupPermissions)
        <div class="mb-4">
            <h5 class="fw-semibold text-primary mb-3">{{ $group ?: __('app.permissions.other') }}</h5>
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('app.permissions.table.name') }}</th>
                            <th>{{ __('app.permissions.table.display_name') }}</th>
                            <th>{{ __('app.permissions.table.description') }}</th>
                            <th>{{ __('app.permissions.table.roles_count') }}</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($groupPermissions as $permission)
                            <tr>
                                <td>
                                    <code class="text-primary">{{ $permission->name }}</code>
                                </td>
                                <td class="fw-semibold">{{ $permission->display_name }}</td>
                                <td class="text-muted small">{{ $permission->description ?: '-' }}</td>
                                <td>
                                    <span class="badge bg-info-subtle text-info">{{ $permission->roles->count() }}</span>
                                </td>
                                <td class="text-end">
                                    <a href="{{ route('admin.permissions.edit', $permission) }}" class="btn btn-sm btn-outline-primary">{{ __('app.permissions.edit') }}</a>
                                    <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $permission->id }}">{{ __('app.permissions.delete') }}</button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endforeach

    @foreach($permissions->flatten() as $permission)
        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal{{ $permission->id }}" tabindex="-1" aria-labelledby="deleteModalLabel{{ $permission->id }}" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header border-0 pb-0">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center px-4 pb-4">
                        <div class="mb-3">
                            <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                            </div>
                        </div>
                        <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel{{ $permission->id }}">{{ __('app.permissions.delete_confirm') }}</h5>
                        <p class="text-muted mb-0">
                            {{ __('app.permissions.table.display_name') }}: <strong>{{ $permission->display_name }}</strong>
                        </p>
                    </div>
                    <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                        <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                            {{ __('app.permissions.form.cancel') }}
                        </button>
                        <form action="{{ route('admin.permissions.destroy', $permission) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-rounded">
                                <i class="bi bi-trash me-2"></i>{{ __('app.permissions.delete') }}
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@endsection




