@extends('layouts.admin', ['title' => __('app.permissions.edit_title')])

@section('admin-content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0">{{ __('app.permissions.edit_permission') }}</h4>
            <p class="text-muted small mb-0">{{ __('app.permissions.edit_description') }}</p>
        </div>
        <a href="{{ route('admin.permissions.index') }}" class="btn btn-outline-secondary btn-rounded">
            <i class="bi bi-arrow-left me-2"></i>{{ __('app.permissions.back') }}
        </a>
    </div>

    <form action="{{ route('admin.permissions.update', $permission) }}" method="POST">
        @csrf
        @method('PUT')

        <div class="row g-3">
            <div class="col-12 col-md-6">
                <label for="name" class="form-label fw-semibold">{{ __('app.permissions.form.name') }}</label>
                <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $permission->name) }}" required>
                <small class="text-muted">{{ __('app.permissions.form.name_hint') }}</small>
                @error('name')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12 col-md-6">
                <label for="display_name" class="form-label fw-semibold">{{ __('app.permissions.form.display_name') }}</label>
                <input type="text" class="form-control @error('display_name') is-invalid @enderror" id="display_name" name="display_name" value="{{ old('display_name', $permission->display_name) }}" required>
                @error('display_name')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12 col-md-6">
                <label for="group" class="form-label fw-semibold">{{ __('app.permissions.form.group') }}</label>
                <input type="text" class="form-control @error('group') is-invalid @enderror" id="group" name="group" value="{{ old('group', $permission->group) }}" placeholder="{{ __('app.permissions.form.group_placeholder') }}">
                <small class="text-muted">{{ __('app.permissions.form.group_hint') }}</small>
                @error('group')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12">
                <label for="description" class="form-label fw-semibold">{{ __('app.permissions.form.description') }}</label>
                <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description', $permission->description) }}</textarea>
                @error('description')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <div class="col-12">
                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary btn-rounded">
                        <i class="bi bi-check-lg me-2"></i>{{ __('app.permissions.form.save') }}
                    </button>
                    <a href="{{ route('admin.permissions.index') }}" class="btn btn-outline-secondary btn-rounded">
                        {{ __('app.permissions.form.cancel') }}
                    </a>
                </div>
            </div>
        </div>
    </form>
@endsection




