@extends('layouts.admin', ['title' => __('app.orders.show.title', ['number' => $serviceOrder->order_number])])

@section('admin-content')
    <div class="d-flex justify-content-between mb-4">
        <div>
            <h4 class="fw-bold mb-1">{{ __('app.orders.show.title', ['number' => $serviceOrder->order_number]) }}</h4>
            <p class="text-muted mb-0">{{ __('app.orders.show.barcode_label') }}: {{ $serviceOrder->barcode }}</p>
        </div>
        <div class="d-flex gap-2">
            <a href="{{ route('service-orders.receipt', ['serviceOrder' => $serviceOrder->id]) }}" target="_blank" class="btn btn-outline-primary btn-rounded">
                <i class="bi bi-printer me-2"></i>{{ __('app.orders.show.print_receipt') }}
            </a>
            @can('manage_orders')
                <button type="button" class="btn btn-outline-danger btn-rounded" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $serviceOrder->id }}">
                    <i class="bi bi-trash me-2"></i>{{ __('app.orders.show.delete') }}
                </button>
            @endcan
        </div>
    </div>

    <div class="row g-4">
        <div class="col-md-7">
            <h6 class="heading-label mb-2">{{ __('app.orders.show.items') }}</h6>
            <div class="table-responsive mb-4">
                <table class="table table-sm align-middle">
                    <thead>
                        <tr>
                            <th>{{ __('app.orders.show.item') }}</th>
                            <th class="text-center">{{ __('app.orders.show.qty') }}</th>
                            <th class="text-end">{{ __('app.orders.show.line_total') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($serviceOrder->items as $item)
                            <tr>
                                <td>
                                    {{ $item->clothingItem->name }}
                                    @if($item->color)
                                        <span class="badge bg-secondary-subtle text-secondary ms-2">{{ __('app.front.colors.' . $item->color) }}</span>
                                    @endif
                                </td>
                                <td class="text-center">{{ $item->quantity }}</td>
                                <td class="text-end">{{ number_format($item->line_total, 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="2" class="text-end">{{ __('app.orders.show.subtotal') }}</td>
                            <td class="text-end">{{ number_format($serviceOrder->subtotal, 2) }}</td>
                        </tr>
                        <tr>
                            <td colspan="2" class="text-end">{{ __('app.orders.show.discount') }}</td>
                            <td class="text-end">- {{ number_format($serviceOrder->discount_amount, 2) }}</td>
                        </tr>
                        <tr>
                            <td colspan="2" class="text-end fw-bold">{{ __('app.orders.show.total') }}</td>
                            <td class="text-end fw-bold">{{ number_format($serviceOrder->total, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
        <div class="col-md-5">
            <h6 class="heading-label mb-2">{{ __('app.orders.show.update_status') }}</h6>
            <form action="{{ route('admin.orders.update', $serviceOrder) }}" method="POST" class="border rounded-4 p-3">
                @csrf
                @method('PUT')
                <div class="mb-3">
                    <label class="form-label">{{ __('app.orders.show.status') }}</label>
                    <select name="status" class="form-select rounded-4">
                        @foreach (['processing','ready','collected'] as $status)
                            <option value="{{ $status }}" @selected($serviceOrder->status === $status)>{{ __('app.orders.show.statuses.' . $status) }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="form-check form-switch mb-3">
                    <input class="form-check-input" type="checkbox" role="switch" id="markPaid" name="mark_paid" value="1" {{ $serviceOrder->payment_status === 'paid' ? 'checked disabled' : '' }}>
                    <label class="form-check-label" for="markPaid">{{ __('app.orders.show.mark_paid') }}</label>
                </div>
                <button class="btn btn-primary btn-rounded" type="submit">{{ __('app.orders.show.save_changes') }}</button>
            </form>

            <div class="mt-4">
                <h6 class="heading-label mb-2">{{ __('app.orders.show.barcode') }}</h6>
                <svg id="adminOrderBarcode" style="width:100%;height:120px;"></svg>
                <small class="text-muted">{{ __('app.orders.show.barcode_hint') }}</small>
            </div>
        </div>
    </div>

    @can('manage_orders')
        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal{{ $serviceOrder->id }}" tabindex="-1" aria-labelledby="deleteModalLabel{{ $serviceOrder->id }}" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header border-0 pb-0">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center px-4 pb-4">
                        <div class="mb-3">
                            <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                            </div>
                        </div>
                        <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel{{ $serviceOrder->id }}">{{ __('app.orders.show.delete_confirm') }}</h5>
                        <p class="text-muted mb-0">
                            {{ __('app.orders.table.order') }}: <strong>{{ $serviceOrder->order_number }}</strong><br>
                            {{ __('app.orders.show.barcode_label') }}: <strong>{{ $serviceOrder->barcode }}</strong>
                        </p>
                    </div>
                    <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                        <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                            {{ __('app.orders.show.cancel') }}
                        </button>
                        <form action="{{ route('admin.orders.destroy', $serviceOrder) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-rounded">
                                <i class="bi bi-trash me-2"></i>{{ __('app.orders.show.delete') }}
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endcan
@endsection

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.6/dist/JsBarcode.all.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            JsBarcode("#adminOrderBarcode", "{{ $serviceOrder->barcode }}", {
                format: "CODE128",
                width: 2,
                height: 80,
                displayValue: true,
            });
        });
    </script>
@endpush


