@extends('layouts.admin', ['title' => __('app.items.title')])

@section('admin-content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0">{{ __('app.items.catalog') }}</h4>
            <p class="text-muted small mb-0">{{ __('app.items.description') }}</p>
        </div>
        <a href="{{ route('admin.items.create') }}" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus-lg me-2"></i>{{ __('app.items.new_item') }}
        </a>
    </div>

    <div class="table-responsive">
        <table class="table align-middle">
            <thead>
                <tr>
                    <th>{{ __('app.items.table.item') }}</th>
                    <th>{{ __('app.items.table.wash') }}</th>
                    <th>{{ __('app.items.table.iron') }}</th>
                    <th>{{ __('app.items.table.status') }}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @foreach ($items as $item)
                    <tr>
                        <td class="d-flex align-items-center gap-3">
                            <img src="{{ $item->image_url }}" alt="" class="rounded-3" style="width:56px;height:56px;object-fit:cover;">
                            <div>
                                <div class="fw-semibold">{{ $item->name }}</div>
                                <small class="text-muted">{{ $item->slug }}</small>
                            </div>
                        </td>
                        <td>{{ number_format($item->default_wash_price, 2) }}</td>
                        <td>{{ number_format($item->default_iron_price, 2) }}</td>
                        <td>
                            <span class="badge {{ $item->is_active ? 'bg-success-subtle text-success' : 'bg-secondary-subtle text-secondary' }}">
                                {{ $item->is_active ? __('app.items.active') : __('app.items.hidden') }}
                            </span>
                        </td>
                        <td class="text-end">
                            <a href="{{ route('admin.items.edit', $item) }}" class="btn btn-sm btn-outline-primary">{{ __('app.items.edit') }}</a>
                            <button class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal{{ $item->id }}">{{ __('app.items.delete') }}</button>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="mt-3">
        {{ $items->links() }}
    </div>

    @foreach ($items as $item)
        <!-- Delete Confirmation Modal -->
        <div class="modal fade" id="deleteModal{{ $item->id }}" tabindex="-1" aria-labelledby="deleteModalLabel{{ $item->id }}" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header border-0 pb-0">
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center px-4 pb-4">
                        <div class="mb-3">
                            <div class="bg-danger-subtle rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 64px; height: 64px;">
                                <i class="bi bi-exclamation-triangle-fill text-danger fs-2"></i>
                            </div>
                        </div>
                        <h5 class="modal-title fw-bold mb-2" id="deleteModalLabel{{ $item->id }}">{{ __('app.items.delete_confirm') }}</h5>
                        <p class="text-muted mb-0">
                            {{ __('app.items.table.item') }}: <strong>{{ $item->name }}</strong>
                        </p>
                    </div>
                    <div class="modal-footer border-0 justify-content-center gap-2 pb-4">
                        <button type="button" class="btn btn-outline-secondary btn-rounded" data-bs-dismiss="modal">
                            {{ __('app.items.form.cancel') }}
                        </button>
                        <form action="{{ route('admin.items.destroy', $item) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-rounded">
                                <i class="bi bi-trash me-2"></i>{{ __('app.items.delete') }}
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@endsection


