@extends('layouts.admin', ['title' => __('app.cashboxes.title')])

@section('admin-content')
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0">{{ __('app.cashboxes.heading') }}</h4>
            <p class="text-muted small mb-0">{{ __('app.cashboxes.description') }}</p>
        </div>
        <a href="{{ route('admin.cashboxes.create') }}" class="btn btn-primary btn-rounded">
            <i class="bi bi-plus me-2"></i>{{ __('app.cashboxes.new_cashbox') }}
        </a>
    </div>

    <div class="row g-3">
        @foreach ($cashboxes as $cashbox)
            <div class="col-md-6">
                <div class="border rounded-4 p-3 h-100">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h5 class="fw-bold mb-1">{{ $cashbox->name }}</h5>
                            <p class="text-muted small mb-2">{{ $cashbox->entries_count }} {{ __('app.cashboxes.movements') }}</p>
                        </div>
                        <div class="text-end">
                            <div class="fw-semibold">{{ __('app.cashboxes.balance') }}</div>
                            <div class="fs-4 fw-bold">{{ number_format($cashbox->current_balance, 2) }}</div>
                        </div>
                    </div>
                    <a href="{{ route('admin.cashboxes.show', $cashbox) }}" class="btn btn-outline-primary btn-sm btn-rounded">{{ __('app.cashboxes.open') }}</a>
                </div>
            </div>
        @endforeach
    </div>
@endsection


