@extends('layouts.admin', ['title' => __('app.cashboxes.edit_title')])

@section('admin-content')
    <form action="{{ route('admin.cashboxes.update', $cashbox) }}" method="POST" class="row g-3">
        @csrf
        @method('PUT')
        <div class="col-md-6">
            <label class="form-label">{{ __('app.cashboxes.form.name') }}</label>
            <input type="text" name="name" class="form-control rounded-4" value="{{ old('name', $cashbox->name) }}" required>
        </div>
        <div class="col-12">
            <label class="form-label">{{ __('app.cashboxes.form.notes') }}</label>
            <textarea name="notes" rows="3" class="form-control rounded-4">{{ old('notes', $cashbox->notes) }}</textarea>
        </div>
        <div class="col-12 d-flex gap-2">
            <button class="btn btn-primary btn-rounded" type="submit">{{ __('app.cashboxes.form.save') }}</button>
            <a href="{{ route('admin.cashboxes.show', $cashbox) }}" class="btn btn-outline-secondary btn-rounded">{{ __('app.cashboxes.form.cancel') }}</a>
        </div>
    </form>
@endsection


