<?php

return [
    'brand' => 'Lavandera',
    'tagline' => 'Suite de blanchisserie professionnelle',
    'locale' => [
        'label' => 'Langue',
        'en' => 'Anglais',
        'ar' => 'Arabe',
        'fr' => 'Français',
    ],
    'nav' => [
        'front' => 'Accueil client',
        'admin' => 'Tableau de bord',
    ],
    'front' => [
        'title' => 'Lavandera · Comptoir',
        'intro' => 'Créer un service',
        'badge' => 'Totaux en direct',
        'heading' => 'Flux d\'accueil ultra-rapide',
        'gender_label' => '1 · Sélectionner le genre',
        'male' => 'Homme',
        'female' => 'Femme',
        'service_label' => '2 · Choisir le service',
        'washing' => 'Lavage',
        'ironing' => 'Repassage',
        'items_label' => '3 · Touchez pour ajouter les articles',
        'search_items' => 'Rechercher des articles...',
        'no_search_results' => 'Aucun résultat trouvé',
        'item_hint' => 'Touchez + pour augmenter la quantité',
        'clear_order' => 'Effacer la commande',
        'clear_order_confirm' => 'Voulez-vous supprimer tous les articles de la commande?',
        'order_cleared' => 'Commande effacée',
        'color_label' => 'Couleur',
        'color_placeholder' => 'Sélectionner la couleur',
        'colors' => [
            'white' => 'Blanc',
            'black' => 'Noir',
            'red' => 'Rouge',
            'blue' => 'Bleu',
            'green' => 'Vert',
            'yellow' => 'Jaune',
            'orange' => 'Orange',
            'purple' => 'Violet',
            'pink' => 'Rose',
            'brown' => 'Marron',
            'gray' => 'Gris',
            'beige' => 'Beige',
            'navy' => 'Bleu marine',
            'other' => 'Autre',
        ],
        'summary' => 'Résumé de la commande',
        'customer' => 'Nom du client',
        'discount' => 'Remise',
        'subtotal' => 'Sous-total',
        'total' => 'Total',
        'mark_paid' => 'Marquer comme payé',
        'save' => 'Enregistrer',
        'save_print' => 'Enregistrer & imprimer',
        'receipt_copies' => 'Copies du reçu',
        'receipt_hint' => 'Les reçus incluent un code-barres dynamique pour la remise et le retrait.',
        'toast_success' => 'Commande enregistrée avec succès.',
        'toast_error' => 'Impossible d\'enregistrer la commande.',
        'walk_in' => 'Client de passage',
        'quantity' => 'Quantité',
        'add_to_cart' => 'Ajouter',
        'added' => 'Ajouté',
        'remove_item' => 'Supprimer l\'article',
        'receipt' => [
            'title' => 'Reçu',
            'copy' => 'Copie',
            'of' => 'de',
            'order' => 'Commande',
            'barcode' => 'Code-barres',
            'date' => 'Date',
            'customer' => 'Client',
            'walk_in' => 'Client de passage',
            'gender' => 'Genre',
            'service' => 'Service',
            'status' => 'Statut',
            'item' => 'Article',
            'qty' => 'Qté',
            'unit' => 'Unité',
            'total' => 'Total',
            'subtotal' => 'Sous-total',
            'discount' => 'Remise',
            'payment_status' => 'Statut du paiement',
            'thank_you' => 'Merci d\'avoir choisi Lavandera.',
            'scan_hint' => 'Scanner à la livraison ou au retrait',
            'print' => 'Imprimer le reçu',
        ],
    ],
    'admin' => [
        'dashboard' => 'Tableau de bord',
        'orders' => 'Commandes',
        'items' => 'Articles & tarifs',
        'transactions' => 'Comptabilité',
        'cashbox' => 'Caisse',
        'settings' => 'Paramètres',
        'users' => 'Utilisateurs',
        'roles' => 'Rôles',
        'permissions' => 'Permissions',
        'quick_actions' => [
            'new_service' => 'Nouvelle commande',
            'settings' => 'Paramètres',
        ],
    ],
    'dashboard_cards' => [
        'processing' => 'Commandes en traitement',
        'ready' => 'Prêtes au retrait',
        'collected' => 'Récupérées aujourd\'hui',
        'revenue' => 'Revenus du jour',
        'expenses' => 'Dépenses du jour',
        'cashbox' => 'Solde de caisse',
        'recent_orders' => 'Commandes récentes',
        'recent_transactions' => 'Transactions récentes',
        'orders_empty' => 'Aucune commande pour le moment.',
        'transactions_empty' => 'Aucune transaction pour le moment.',
    ],
    'orders' => [
        'search' => 'Recherche',
        'status' => 'Statut',
        'all' => 'Tous',
        'filter' => 'Filtrer',
        'barcode' => 'Code-barres',
        'new_service' => 'Nouvelle commande',
        'table' => [
            'order' => 'Commande',
            'customer' => 'Client',
            'service' => 'Service',
            'total' => 'Total',
            'status' => 'Statut',
            'payment' => 'Paiement',
            'actions' => 'Actions',
        ],
        'manage' => 'Gérer',
        'none' => 'Aucune commande.',
        'items_count' => '{0} Aucun article|{1} :count article|[2,*] :count articles',
        'show' => [
            'title' => 'Commande :number',
            'barcode_label' => 'Code-barres',
            'print_receipt' => 'Imprimer le reçu',
            'items' => 'Articles',
            'item' => 'Article',
            'qty' => 'Qté',
            'line_total' => 'Total ligne',
            'subtotal' => 'Sous-total',
            'discount' => 'Remise',
            'total' => 'Total',
            'update_status' => 'Mettre à jour le statut',
            'status' => 'Statut',
            'mark_paid' => 'Marquer comme payé',
            'save_changes' => 'Enregistrer les modifications',
            'barcode' => 'Code-barres',
            'barcode_hint' => 'Scannez pour confirmer la finition ou le retrait.',
            'delete' => 'Supprimer la commande',
            'delete_confirm' => 'Êtes-vous sûr de vouloir supprimer cette commande ?',
            'cancel' => 'Annuler',
            'deleted' => 'Commande :number supprimée avec succès.',
            'statuses' => [
                'pending' => 'En attente',
                'processing' => 'En traitement',
                'ready' => 'Prêt',
                'completed' => 'Terminé',
                'collected' => 'Récupéré',
                'paid' => 'Payé',
                'unpaid' => 'Non payé',
            ],
            'updated' => 'Commande mise à jour avec succès.',
        ],
    ],
    'items' => [
        'title' => 'Articles & tarifs',
        'catalog' => 'Catalogue d\'articles',
        'description' => 'Contrôler les tarifs pour lavage & repassage.',
        'new_item' => 'Nouvel article',
        'table' => [
            'item' => 'Article',
            'wash' => 'Lavage',
            'iron' => 'Repassage',
            'status' => 'Statut',
            'actions' => 'Actions',
        ],
        'active' => 'Actif',
        'hidden' => 'Masqué',
        'edit' => 'Modifier',
        'delete' => 'Supprimer',
        'delete_confirm' => 'Supprimer cet article ?',
        'form' => [
            'name' => 'Nom',
            'slug' => 'Slug',
            'slug_placeholder' => 'généré automatiquement si vide',
            'image' => 'Image',
            'image_hint' => 'Téléchargez un fichier image (JPG, PNG, GIF, WebP, max 2MB)',
            'washing_price' => 'Prix de lavage',
            'ironing_price' => 'Prix de repassage',
            'active' => 'Actif',
            'save' => 'Enregistrer',
            'cancel' => 'Annuler',
        ],
        'new_title' => 'Nouvel article',
        'edit_title' => 'Modifier l\'article',
        'created' => 'Article créé avec succès.',
        'updated' => 'Article mis à jour avec succès.',
        'deleted' => 'Article supprimé.',
    ],
    'cashboxes' => [
        'title' => 'Caisses',
        'heading' => 'Trésorerie',
        'description' => 'Contrôler les caisses physiques.',
        'new_cashbox' => 'Nouvelle caisse',
        'balance' => 'Solde',
        'movements' => 'mouvements',
        'open' => 'Ouvrir',
        'new_title' => 'Nouvelle caisse',
        'edit_title' => 'Modifier la caisse',
        'form' => [
            'name' => 'Nom',
            'starting_balance' => 'Solde initial',
            'notes' => 'Notes',
            'save' => 'Enregistrer',
            'cancel' => 'Annuler',
        ],
        'show' => [
            'balance' => 'Solde',
            'edit' => 'Modifier',
            'date' => 'Date',
            'direction' => 'Direction',
            'amount' => 'Montant',
            'balance' => 'Solde',
            'in' => 'Entrée',
            'out' => 'Sortie',
            'none' => 'Aucune entrée pour le moment.',
            'actions' => 'Actions',
            'locked' => 'Verrouillé',
            'delete' => 'Supprimer',
            'delete_confirm' => 'Êtes-vous sûr de vouloir supprimer cette entrée ?',
            'cancel' => 'Annuler',
            'entry_deleted' => 'Entrée supprimée avec succès.',
            'cannot_delete_locked' => 'Impossible de supprimer une entrée liée à une commande de service.',
            'linked_to_order' => 'Liée à une commande de service',
        ],
        'created' => 'Caisse créée avec succès.',
        'updated' => 'Caisse mise à jour avec succès.',
        'deleted' => 'Caisse supprimée.',
        'cannot_delete_with_entries' => 'Impossible de supprimer une caisse avec des entrées.',
    ],
    'settings' => [
        'title' => 'Paramètres',
        'company_name' => 'Nom de l\'entreprise',
        'phone' => 'Téléphone',
        'address' => 'Adresse',
        'barcode_prefix' => 'Préfixe code-barres',
        'order_prefix' => 'Préfixe commande',
        'receipt_copies' => 'Copies du reçu',
        'currency' => 'Devise',
        'save_changes' => 'Enregistrer les modifications',
        'cancel' => 'Annuler',
        'updated' => 'Paramètres enregistrés avec succès.',
    ],
    'transactions' => [
        'title' => 'Comptabilité',
        'cashflow_monitor' => 'Suivi des flux de trésorerie',
        'description' => 'Suivez les revenus, dépenses et trésorerie.',
        'new_transaction' => 'Nouvelle transaction',
        'type' => 'Type',
        'all' => 'Tous',
        'income' => 'Revenu',
        'expense' => 'Dépense',
        'from' => 'De',
        'to' => 'À',
        'apply' => 'Appliquer',
        'date' => 'Date',
        'category' => 'Catégorie',
        'amount' => 'Montant',
        'cashbox' => 'Caisse',
        'description' => 'Description',
        'optional_notes' => 'Notes optionnelles',
        'save' => 'Enregistrer',
        'cancel' => 'Annuler',
        'view' => 'Voir',
        'edit' => 'Modifier',
        'delete' => 'Supprimer',
        'back' => 'Retour',
        'locked' => 'Verrouillé',
        'none' => 'Aucune transaction enregistrée.',
        'new_title' => 'Nouvelle Transaction',
        'edit_title' => 'Modifier la Transaction',
        'show_title' => 'Transaction',
        'delete_confirm' => 'Supprimer cette transaction ?',
        'created' => 'Transaction enregistrée.',
        'updated' => 'Transaction mise à jour.',
        'deleted' => 'Transaction supprimée.',
        'locked_error' => 'Les transactions générées automatiquement sont verrouillées.',
        'cannot_delete' => 'Les transactions générées automatiquement ne peuvent pas être supprimées.',
    ],
    'users' => [
        'title' => 'Utilisateurs',
        'description' => 'Gérer les utilisateurs et les rôles.',
        'new_user' => 'Nouvel utilisateur',
        'new_title' => 'Nouvel utilisateur',
        'edit_title' => 'Modifier l\'utilisateur',
        'edit_user' => 'Modifier l\'utilisateur',
        'create_description' => 'Ajouter un nouvel utilisateur au système.',
        'edit_description' => 'Modifier les informations de l\'utilisateur.',
        'back' => 'Retour',
        'no_role' => 'Aucun rôle',
        'table' => [
            'name' => 'Nom',
            'email' => 'Email',
            'role' => 'Rôle',
            'created' => 'Créé',
        ],
        'form' => [
            'name' => 'Nom',
            'email' => 'Email',
            'password' => 'Mot de passe',
            'password_confirmation' => 'Confirmer le mot de passe',
            'password_optional' => 'Laissez vide si vous ne voulez pas changer le mot de passe',
            'role' => 'Rôle',
            'select_role' => 'Sélectionner un rôle',
            'save' => 'Enregistrer',
            'cancel' => 'Annuler',
        ],
        'edit' => 'Modifier',
        'delete' => 'Supprimer',
        'delete_confirm' => 'Voulez-vous supprimer cet utilisateur ?',
        'created' => 'Utilisateur créé avec succès.',
        'updated' => 'Utilisateur mis à jour avec succès.',
        'deleted' => 'Utilisateur supprimé.',
        'cannot_delete_self' => 'Vous ne pouvez pas supprimer votre propre compte.',
    ],
    'roles' => [
        'title' => 'Rôles',
        'description' => 'Gérer les rôles et les permissions.',
        'new_role' => 'Nouveau rôle',
        'new_title' => 'Nouveau rôle',
        'edit_title' => 'Modifier le rôle',
        'edit_role' => 'Modifier le rôle',
        'create_description' => 'Ajouter un nouveau rôle avec des permissions.',
        'edit_description' => 'Modifier le rôle et ses permissions.',
        'back' => 'Retour',
        'other' => 'Autre',
        'table' => [
            'name' => 'Nom',
            'display_name' => 'Nom d\'affichage',
            'users_count' => 'Utilisateurs',
            'permissions_count' => 'Permissions',
        ],
        'form' => [
            'name' => 'Nom',
            'name_hint' => 'Nom de rôle unique (ex: admin, manager)',
            'display_name' => 'Nom d\'affichage',
            'description' => 'Description',
            'permissions' => 'Permissions',
            'save' => 'Enregistrer',
            'cancel' => 'Annuler',
        ],
        'edit' => 'Modifier',
        'delete' => 'Supprimer',
        'delete_confirm' => 'Voulez-vous supprimer ce rôle ?',
        'created' => 'Rôle créé avec succès.',
        'updated' => 'Rôle mis à jour avec succès.',
        'deleted' => 'Rôle supprimé.',
        'cannot_delete_system' => 'Impossible de supprimer les rôles système (admin, manager, cashier).',
    ],
    'permissions' => [
        'title' => 'Permissions',
        'description' => 'Gérer les permissions disponibles dans le système.',
        'new_permission' => 'Nouvelle permission',
        'new_title' => 'Nouvelle permission',
        'edit_title' => 'Modifier la permission',
        'edit_permission' => 'Modifier la permission',
        'create_description' => 'Ajouter une nouvelle permission au système.',
        'edit_description' => 'Modifier les informations de la permission.',
        'back' => 'Retour',
        'other' => 'Autre',
        'table' => [
            'name' => 'Nom',
            'display_name' => 'Nom d\'affichage',
            'description' => 'Description',
            'roles_count' => 'Rôles',
        ],
        'form' => [
            'name' => 'Nom',
            'name_hint' => 'Nom de permission unique (ex: manage_users, view_orders)',
            'display_name' => 'Nom d\'affichage',
            'description' => 'Description',
            'group' => 'Groupe',
            'group_placeholder' => 'ex: users, orders, settings',
            'group_hint' => 'Pour regrouper les permissions similaires',
            'save' => 'Enregistrer',
            'cancel' => 'Annuler',
        ],
        'edit' => 'Modifier',
        'delete' => 'Supprimer',
        'delete_confirm' => 'Voulez-vous supprimer cette permission ?',
        'created' => 'Permission créée avec succès.',
        'updated' => 'Permission mise à jour avec succès.',
        'deleted' => 'Permission supprimée.',
    ],
    'auth' => [
        'login' => 'Connexion',
        'logout' => 'Déconnexion',
        'email' => 'Email',
        'password' => 'Mot de passe',
        'remember_me' => 'Se souvenir de moi',
        'login_description' => 'Connectez-vous pour accéder au tableau de bord',
        'failed' => 'Ces identifiants ne correspondent pas à nos enregistrements.',
        'logged_out' => 'Vous avez été déconnecté avec succès.',
        'permission_denied' => 'Vous n\'avez pas la permission d\'accéder à cette page.',
    ],
    'trial' => [
        'expired_title' => 'Période d\'essai expirée',
        'expired_message' => 'La période d\'essai de 20 jours est terminée. Veuillez activer votre licence pour continuer à utiliser le système.',
        'trial_info' => 'Informations sur la période d\'essai',
        'start_date' => 'Date de début',
        'end_date' => 'Date de fin',
        'total_days' => 'Durée totale',
        'days' => 'jours',
        'days_remaining' => 'Jours restants',
        'activate_license' => 'Activer la licence',
        'back_to_login' => 'Retour à la connexion',
        'back_to_dashboard' => 'Retour au tableau de bord',
        'contact_support' => 'Pour obtenir une licence, veuillez contacter le support',
        'warning_title' => 'Avertissement : Période d\'essai',
        'warning_message' => 'La période d\'essai expirera dans :days jour(s). Veuillez activer votre licence pour continuer à utiliser le système.',
        'remaining' => 'restants',
        'dismiss' => 'Masquer',
        'test_title' => 'Tester la période d\'essai',
        'test_subtitle' => 'Afficher les informations sur la période d\'essai et la licence',
        'status' => 'Statut',
        'is_expired' => 'Est expirée',
        'is_expiring_soon' => 'Expire bientôt',
        'current_date' => 'Date actuelle',
        'yes' => 'Oui',
        'no' => 'Non',
        'no_license' => 'Aucune licence activée',
        'activate_to_continue' => 'Veuillez activer votre licence pour continuer à utiliser le système',
        'detailed_info' => 'Informations détaillées',
        'view_expired' => 'Voir la page d\'expiration',
        'test_buttons' => 'Boutons de test',
        'test_buttons_desc' => 'Utilisez ces boutons pour tester différents scénarios de période d\'essai',
        'set_18_days' => 'Définir 18 jours (Avertissement - 2 jours restants)',
        'set_21_days' => 'Réinitialiser (20 jours supplémentaires)',
        'set_0_days' => 'Définir 0 jour (Totalement expirée)',
        'test_date_set' => 'Date de la période d\'essai définie à :days jours restants',
        'test_date_set_warning' => 'Date définie : 18 jours écoulés, 2 jours restants (l\'avertissement s\'affichera)',
        'trial_reset' => 'Période d\'essai réinitialisée avec succès (20 nouveaux jours)',
        'invalid_days' => 'Nombre de jours invalide',
    ],
    'license' => [
        'activate_title' => 'Activer la licence',
        'activate_subtitle' => 'Entrez votre clé de licence et votre numéro de série pour activer le système',
        'license_key' => 'Clé de licence',
        'license_key_hint' => 'Format : XXXX-XXXX-XXXX-XXXX',
        'serial_number' => 'Numéro de série',
        'serial_number_hint' => 'Format : SN-XXXXXXXXXXXX',
        'customer_name' => 'Nom du client',
        'email' => 'E-mail',
        'activate' => 'Activer',
        'activated' => 'Activé avec succès',
        'license_info' => 'Le système est actuellement activé',
        'expires_at' => 'Expire le',
        'back_to_login' => 'Retour à la connexion',
    ],
    'footer' => [
        'description' => 'Système de gestion de blanchisserie professionnel offrant des solutions complètes pour la gestion des commandes et la comptabilité.',
        'quick_links' => 'Liens rapides',
        'contact' => 'Contactez-nous',
        'info' => 'Informations',
        'email' => 'Support@imranesoft.com',
        'phone' => '+212 674 42 77 48',
        'address' => 'Maroc',
        'version' => 'Version',
        'year' => 'Année',
        'license' => 'Licence commerciale',
        'all_rights_reserved' => 'Tous droits réservés',
        'developed_by' => 'Développé par ImraneSoft',
    ],
];
