<?php

namespace Database\Seeders;

use App\Models\Cashbox;
use App\Models\ClothingItem;
use App\Models\Setting;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Seed roles and permissions first
        $this->call(RolePermissionSeeder::class);

        $items = [
            ['Shirt', 'shirt', 'https://images.unsplash.com/photo-1484519332611-516457305ff6?auto=format&fit=crop&w=400&q=60', 8, 5],
            ['Pants', 'pants', 'https://images.unsplash.com/photo-1521572267360-ee0c2909d518?auto=format&fit=crop&w=400&q=60', 10, 6],
            ['Suit', 'suit', 'https://images.unsplash.com/photo-1475180098004-ca77a66827be?auto=format&fit=crop&w=400&q=60', 25, 15],
            ['Dress', 'dress', 'https://images.unsplash.com/photo-1503341455253-b2e723bb3dbb?auto=format&fit=crop&w=400&q=60', 20, 12],
            ['Jacket', 'jacket', 'https://images.unsplash.com/photo-1509631179647-0177331693ae?auto=format&fit=crop&w=400&q=60', 18, 11],
        ];

        foreach ($items as [$name, $slug, $image, $wash, $iron]) {
            ClothingItem::firstOrCreate(
                ['slug' => $slug],
                [
                    'name' => $name,
                    'image_path' => $image,
                    'default_wash_price' => $wash,
                    'default_iron_price' => $iron,
                ]
            );
        }

        Cashbox::firstOrCreate(
            ['name' => 'Main Cashbox'],
            ['starting_balance' => 0, 'current_balance' => 0]
        );

        Setting::setValue('company_name', 'Lavandera');
        Setting::setValue('barcode_prefix', 'MSB');
        Setting::setValue('receipt_copies', '2');
        Setting::setValue('currency', 'USD');
    }
}
