<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    protected $connection = 'activation';

    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::connection('activation')->create('activation_keys', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->integer('days')->default(30);
            $table->boolean('is_used')->default(false);
            $table->timestamp('used_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::connection('activation')->dropIfExists('activation_keys');
    }
};
