<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphMany;

class ServiceOrder extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_number',
        'barcode',
        'customer_name',
        'gender',
        'service_type',
        'subtotal',
        'discount_amount',
        'total',
        'status',
        'payment_status',
        'cashbox_id',
        'notes',
        'completed_at',
        'collected_at',
    ];

    protected $casts = [
        'subtotal' => 'decimal:2',
        'discount_amount' => 'decimal:2',
        'total' => 'decimal:2',
        'completed_at' => 'datetime',
        'collected_at' => 'datetime',
    ];

    public function items(): HasMany
    {
        return $this->hasMany(ServiceOrderItem::class);
    }

    public function cashbox(): BelongsTo
    {
        return $this->belongsTo(Cashbox::class);
    }

    public function transactions(): MorphMany
    {
        return $this->morphMany(FinancialTransaction::class, 'reference');
    }
}
