<?php

namespace App\Http\Controllers;

use App\Services\TrialService;
use Illuminate\Http\Request;

class TrialController extends Controller
{
    protected $trialService;

    public function __construct(TrialService $trialService)
    {
        $this->trialService = $trialService;
    }

    /**
     * عرض صفحة انتهاء الفترة التجريبية
     */
    public function expired()
    {
        $trialInfo = $this->trialService->getTrialInfo();
        
        return view('trial.expired', compact('trialInfo'));
    }

    /**
     * صفحة اختبار الفترة التجريبية
     */
    public function test()
    {
        $trialInfo = $this->trialService->getTrialInfo();
        $startDate = $this->trialService->getStartDate();
        $endDate = $this->trialService->getEndDate();
        $isExpired = $this->trialService->isExpired();
        $isExpiringSoon = $this->trialService->isExpiringSoon();
        $daysRemaining = $this->trialService->getDaysRemaining();
        
        return view('trial.test', compact('trialInfo', 'startDate', 'endDate', 'isExpired', 'isExpiringSoon', 'daysRemaining'));
    }

    /**
     * تغيير تاريخ الفترة التجريبية للاختبار
     */
    public function setTestDate(Request $request, $days)
    {
        $days = (int)$days;
        
        if ($days == 21) {
            // إعادة تعيين الفترة التجريبية (20 يوم إضافية)
            $this->trialService->resetTrial();
            return redirect()->route('trial.test')
                ->with('success', __('app.trial.trial_reset'));
        } elseif ($days == 18) {
            // 18 يوم مرت = 2 يوم متبقي (يظهر التحذير لأن 2 < 3)
            // إذا مر 18 يوم من 20 يوم، يبقى 2 يوم فقط
            // التحذير يظهر عندما يبقى 3 أيام أو أقل
            $daysAgo = 18; // 18 يوم مرت من تاريخ البدء
            $this->trialService->setStartDate($daysAgo);
            return redirect()->route('trial.test')
                ->with('success', __('app.trial.test_date_set_warning', ['days' => $days]));
        } elseif ($days == 0) {
            // 0 يوم = -20 يوم (منتهية تماماً)
            $daysAgo = 20 - $days; // 20 يوم
            $this->trialService->setStartDate($daysAgo);
            return redirect()->route('trial.test')
                ->with('success', __('app.trial.test_date_set', ['days' => $days]));
        }
        
        return redirect()->route('trial.test')
            ->with('error', __('app.trial.invalid_days'));
    }
}



