<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Cashbox;
use App\Models\FinancialTransaction;
use App\Models\ServiceOrder;
use App\Services\TrialService;
use App\Services\LicenseService;
use Illuminate\Support\Carbon;

class DashboardController extends Controller
{
    public function index(TrialService $trialService, LicenseService $licenseService)
    {
        $today = Carbon::today();

        $stats = [
            'processing_orders' => ServiceOrder::where('status', 'processing')->count(),
            'ready_orders' => ServiceOrder::where('status', 'ready')->count(),
            'collected_today' => ServiceOrder::where('status', 'collected')
                ->whereDate('collected_at', $today)->count(),
            'revenue_today' => FinancialTransaction::where('type', 'income')
                ->whereDate('occurred_on', $today)
                ->sum('amount'),
            'expenses_today' => FinancialTransaction::where('type', 'expense')
                ->whereDate('occurred_on', $today)
                ->sum('amount'),
            'cashbox_balance' => Cashbox::sum('current_balance'),
        ];

        $recentOrders = ServiceOrder::latest()->with('items.clothingItem')->take(5)->get();
        $recentTransactions = FinancialTransaction::latest()->take(5)->get();

        // Trial and License info
        $hasLicense = $licenseService->verifyLocal();
        $trialInfo = $trialService->getTrialInfo();
        $licenseInfo = $licenseService->getLicenseInfo();

        return view('admin.dashboard', compact('stats', 'recentOrders', 'recentTransactions', 'hasLicense', 'trialInfo', 'licenseInfo'));
    }
}
